package jamezo97.clonecraft.block;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.network.Handler;
import jamezo97.clonecraft.network.Handler0UpdateCentrifugeInfo;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public class TileEntityCentrifuge extends TileEntity implements IInventory {
	public ItemStack[] items = null;

	public int furnaceBurnTime = 0, currentItemBurnTime = 0, timeSpun = 0;
	public int spin, lastSpin;
	float speed = 0;
	
	int spinSpeedMax = 99;
	
	long ticks = 0;
	
	public boolean spinPressed = false;
	
	public TileEntityCentrifuge() {
		items = new ItemStack[5];
	}
	
    public ItemStack getStackInSlotOnClosing(int par1)
    {
        if (items[par1] != null)
        {
            ItemStack itemstack = items[par1];
            items[par1] = null;
            return itemstack;
        }
        else
        {
            return null;
        }
    }

	public boolean canSpin() {
		boolean canSpin = false;
		for (int a = 0; a < 4; a++) {
			ItemStack item = items[a];
			if (item != null) {
				if (item.itemID == CloneCraft.testTube.itemID && item.getItemDamage() == 1){
					canSpin = true;
				}else{
					canSpin = false;
					break;
				}
			}
		}
		return canSpin;
	}

	public void closeChest() {
	}

	public ItemStack decrStackSize(int i, int j) {
		if (items[i] != null) {
			if (items[i].stackSize <= j) {
				ItemStack itemstack = items[i];
				items[i] = null;
				return itemstack;
			}
			ItemStack itemstack1 = items[i].splitStack(j);
			if (items[i].stackSize == 0) {
				items[i] = null;
			}
			return itemstack1;
		} else {
			return null;
		}
	}

	public float getFuelDone() {
		return (((float) furnaceBurnTime / ((float) currentItemBurnTime)));
	}

	@Override
	public int getInventoryStackLimit() {
		return 64;
	}

	@Override
	public String getInvName() {
		return "Centrifuge";
	}

	//2400
	float spinTime = CloneCraft.isDebugMode()?120:2400;//200;//6400f;
	public float getPercentDone() {
		return (((float) timeSpun) / spinTime);
	}

	@Override
	public int getSizeInventory() {
		return items.length;
	}

	@Override
	public ItemStack getStackInSlot(int i) {
		return items[i];
	}

	public boolean isBurning() {
		return furnaceBurnTime > 0;
	}

	public boolean isSpinning() {
		return timeSpun > 0;
	}

	public boolean isUseableByPlayer(EntityPlayer entityplayer) {
		if (worldObj.getBlockTileEntity(xCoord, yCoord, zCoord) != this) {
			return false;
		}
		return entityplayer.getDistanceSq((double) xCoord + 0.5D,
				(double) yCoord + 0.5D, (double) zCoord + 0.5D) <= 64D;
	}

	@Override
	public void openChest() {
	}

	public void readFromNBT(NBTTagCompound nbttagcompound) {
		super.readFromNBT(nbttagcompound);
		NBTTagList nbttaglist = nbttagcompound.getTagList("Items");
		items = new ItemStack[getSizeInventory()];
		for (int i = 0; i < nbttaglist.tagCount(); i++) {
			NBTTagCompound nbttagcompound1 = (NBTTagCompound) nbttaglist
					.tagAt(i);
			byte byte0 = nbttagcompound1.getByte("Slot");
			if (byte0 >= 0 && byte0 < items.length) {
				items[byte0] = ItemStack.loadItemStackFromNBT(nbttagcompound1);
			}
		}
		furnaceBurnTime = nbttagcompound.getInteger("furnaceBurnTime");
		currentItemBurnTime = nbttagcompound.getInteger("currentItemBurnTime");
		timeSpun = nbttagcompound.getInteger("timeSpun");
		spinPressed = nbttagcompound.getBoolean("spinPressed");
		speed = nbttagcompound.getFloat("speed");
	}

	public void setInventorySlotContents(int i, ItemStack itemstack) {
		items[i] = itemstack;
		if (itemstack != null && itemstack.stackSize > getInventoryStackLimit()) {
			itemstack.stackSize = getInventoryStackLimit();
		}
	}

	public void spin() {
		for (int a = 0; a < 4; a++) {
			ItemStack item = items[a];
			if (item != null) {
				item.setItemDamage(2);
			}
		}
	}

	@Override
	public void updateEntity() {
		boolean updateItems = false;
		if (furnaceBurnTime > 0) {
			furnaceBurnTime--;
		}
		if (furnaceBurnTime == 0 && canSpin() && spinPressed) {
			currentItemBurnTime = furnaceBurnTime = TileEntityFurnace.getItemBurnTime(items[4]);
			if (furnaceBurnTime > 0) {
				items[4].stackSize--;
				if (items[4].stackSize <= 0) {
					items[4] = null;
				}
			}
		}
		if (isBurning() && canSpin() && spinPressed) {
			if(speed <= 0){
				speed = .2f;
			}
			if(speed < spinSpeedMax){
				speed *= 1.1f;
			}
			if(speed > spinSpeedMax){
				speed = spinSpeedMax;
			}
			timeSpun++;
			if (timeSpun >= spinTime) {
				timeSpun = 0;
				spinPressed = false;
				updateItems = true;
				spin();
			}
		} else {
			if(speed > 0){
				speed /= 1.2f;
			}
			if(speed < .1){
				speed = 0;
			}
			if(spinPressed){
				spinPressed = false;
			}
			timeSpun = 0;
		}
		lastSpin = spin;
		spin += speed;

		if (updateItems) {
			onInventoryChanged();
		}
		if(!worldObj.isRemote && ticks % 20 == 0){
			updateToUnknownPlayers();
		}
		if(worldObj.isRemote && (isSpinning() || speed > 15)){
			worldObj.playSound(xCoord+0.5, yCoord+0.5, zCoord+0.5, "clonecraft.spin", 0.75f, 1.0f + ((float)speed / (float)spinSpeedMax)/2.0f, true);
		}
		ticks++;
	}

	ArrayList<EntityPlayerMP> players = new ArrayList<EntityPlayerMP>();
	
	private void updateToUnknownPlayers() {
		List list = worldObj.getEntitiesWithinAABB(EntityPlayerMP.class, AxisAlignedBB.getBoundingBox(xCoord, yCoord, zCoord, xCoord+1, yCoord+1, zCoord+1).expand(64, 32, 64));
		ArrayList<EntityPlayerMP> playersOut = new ArrayList<EntityPlayerMP>();
		ArrayList<EntityPlayerMP> newPlayers = new ArrayList<EntityPlayerMP>();
		for(int a = 0; a < list.size(); a++){
			Object o = list.get(a);
			if(o != null && o instanceof EntityPlayerMP){
				EntityPlayerMP player = (EntityPlayerMP)o;
				if(!players.contains(player)){
					newPlayers.add(player);
				}
				playersOut.add(player);
			}
		}
		players = playersOut;
		for(int a = 0; a < newPlayers.size(); a++){
			EntityPlayerMP player = newPlayers.get(a);
			if(player != null){
				NBTTagCompound nbt = new NBTTagCompound();
				writeToNBT(nbt);
				Handler h;
				h = new Handler0UpdateCentrifugeInfo(nbt);
				h.sendToClient(player);
			}
		}
	}

	public float getSpin(float ticks){
		return (getSpinNow() - getLastSpin())*ticks + getSpinNow();
	}

	public float getSpinNow(){
		return spin;
	}
	
	public float getLastSpin(){
		return lastSpin;
	}

	public void writeToNBT(NBTTagCompound nbttagcompound) {
		super.writeToNBT(nbttagcompound);
		NBTTagList nbttaglist = new NBTTagList();
		for (int i = 0; i < items.length; i++) {
			if (items[i] != null) {
				NBTTagCompound nbttagcompound1 = new NBTTagCompound();
				nbttagcompound1.setByte("Slot", (byte) i);
				items[i].writeToNBT(nbttagcompound1);
				nbttaglist.appendTag(nbttagcompound1);
			}
		}
		nbttagcompound.setInteger("timeSpun", timeSpun);
		nbttagcompound.setInteger("currentItemBurnTime", currentItemBurnTime);
		nbttagcompound.setInteger("furnaceBurnTime", furnaceBurnTime);
		nbttagcompound.setBoolean("spinPressed", spinPressed);
		nbttagcompound.setTag("Items", nbttaglist);
		nbttagcompound.setFloat("speed", speed);
	}

	public void dropAllItems(World world, int x, int y, int z) {
		if(!world.isRemote){
			Random r = new Random();
			for(int a = 0; a < items.length; a++){
				if(items[a] != null){
					EntityItem item = new EntityItem(world, x+.5, y+.5, z+.5, items[a]);
					item.delayBeforeCanPickup = 10;
					item.setVelocity(get(r), (isSpinning()?.6f:.2f), get(r));
					world.spawnEntityInWorld(item);
				}
			}
		}
	}
	
	public float get(Random r){
		if(this.isSpinning()){
			return r.nextFloat()/.85f;
		}else{
			return r.nextFloat()/10;
		}
	}

	@Override
	public boolean isInvNameLocalized() {
		return false;
	}


	@Override
	public boolean isItemValidForSlot(int i, ItemStack itemstack) {
		// TODO Auto-generated method stub
		return true;
	}




}
